/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base.asm;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import dev.onyxstudios.cca.internal.base.AbstractComponentContainer;
import dev.onyxstudios.cca.internal.base.QualifiedComponentFactory;
import dev.onyxstudios.cca.internal.base.asm.CcaBootstrap;
import dev.onyxstudios.cca.internal.base.asm.CcaClassLoader;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.minecraft.class_2960;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;

public final class CcaAsmHelper {
    public static final boolean DEBUG_CLASSES = Boolean.getBoolean("cca.debug.asm");
    public static final int ASM_VERSION = 393216;
    public static final String COMPONENT = Type.getInternalName(Component.class);
    public static final String COMPONENT_CONTAINER = Type.getInternalName(ComponentContainer.class);
    public static final String COMPONENT_TYPE = Type.getInternalName(ComponentKey.class);
    public static final String DYNAMIC_COMPONENT_CONTAINER_IMPL = Type.getInternalName(AbstractComponentContainer.class);
    public static final String IDENTIFIER = (FabricLauncherBase.getLauncher() == null ? class_2960.class.getName() : FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", "net.minecraft.class_2960")).replace('.', '/');
    public static final String EVENT = Type.getInternalName(Event.class);
    public static final String STATIC_COMPONENT_CONTAINER = "dev/onyxstudios/cca/_generated_/GeneratedComponentContainer";
    public static final String STATIC_CONTAINER_GETTER_DESC = "()L" + COMPONENT + ";";
    public static final String STATIC_COMPONENT_TYPE = "dev/onyxstudios/cca/_generated_/ComponentType";
    public static final String STATIC_CONTAINER_FACTORY = "dev/onyxstudios/cca/_generated_/GeneratedContainerFactory";
    public static final String ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC;

    public static Class<?> generateClass(ClassNode classNode) throws IOException {
        ClassWriter writer = new ClassWriter(2);
        classNode.accept((ClassVisitor)writer);
        return CcaAsmHelper.generateClass(writer, classNode.name);
    }

    private static Class<?> generateClass(ClassWriter classWriter, String className) throws IOException {
        try {
            byte[] bytes = classWriter.toByteArray();
            if (DEBUG_CLASSES) {
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)new CheckClassAdapter(null), 0);
                Path path = Paths.get(classReader.getClassName() + ".class", new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, bytes, new OpenOption[0]);
            }
            return CcaClassLoader.INSTANCE.define(className.replace('/', '.'), bytes);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            throw new IOException("Failed to generate class " + className, e);
        }
    }

    public static String getComponentTypeName(class_2960 identifier) {
        return "dev/onyxstudios/cca/_generated_/ComponentType$" + CcaAsmHelper.getJavaIdentifierName(identifier);
    }

    public static String getJavaIdentifierName(class_2960 identifier) {
        return identifier.toString().replace(':', '$').replace('/', '$').replace('.', '\u00a4').replace('-', '\u00a3');
    }

    public static String getStaticStorageGetterName(class_2960 identifier) {
        return "get$" + CcaAsmHelper.getJavaIdentifierName(identifier);
    }

    public static Method findSam(Class<?> callbackClass) {
        if (!callbackClass.isInterface()) {
            throw CcaAsmHelper.badFunctionalInterface(callbackClass);
        }
        Method ret = null;
        for (Method m : callbackClass.getMethods()) {
            if (!Modifier.isAbstract(m.getModifiers())) continue;
            if (ret != null) {
                throw CcaAsmHelper.badFunctionalInterface(callbackClass);
            }
            ret = m;
        }
        if (ret == null) {
            throw CcaAsmHelper.badFunctionalInterface(callbackClass);
        }
        return ret;
    }

    private static IllegalArgumentException badFunctionalInterface(Class<?> callbackClass) {
        return new IllegalArgumentException(callbackClass + " is not a functional interface!");
    }

    @Deprecated(forRemoval=true)
    public static <I> Class<? extends ComponentContainer> spinComponentContainer(Class<? super I> componentFactoryType, Map<ComponentKey<?>, I> componentFactories, Map<ComponentKey<?>, Class<? extends Component>> componentImpls, String implNameSuffix) throws IOException {
        LinkedHashMap merged = new LinkedHashMap();
        for (Map.Entry<ComponentKey<?>, I> entry : componentFactories.entrySet()) {
            merged.put(entry.getKey(), new QualifiedComponentFactory<I>(entry.getValue(), componentImpls.get(entry.getKey()), Set.of()));
        }
        return CcaAsmHelper.spinComponentContainer(componentFactoryType, merged, implNameSuffix);
    }

    public static <I> Class<? extends ComponentContainer> spinComponentContainer(Class<? super I> componentFactoryType, Map<ComponentKey<?>, QualifiedComponentFactory<I>> componentFactories, String implNameSuffix) throws IOException {
        CcaBootstrap.INSTANCE.ensureInitialized();
        QualifiedComponentFactory.checkDependenciesSatisfied(componentFactories);
        Map<ComponentKey<?>, QualifiedComponentFactory<I>> sorted = QualifiedComponentFactory.sort(componentFactories);
        CcaAsmHelper.checkValidJavaIdentifier(implNameSuffix);
        String containerImplName = "dev/onyxstudios/cca/_generated_/GeneratedComponentContainer_" + implNameSuffix;
        String componentFactoryName = Type.getInternalName(componentFactoryType);
        Method sam = CcaAsmHelper.findSam(componentFactoryType);
        String samDescriptor = Type.getMethodDescriptor((Method)sam);
        Class<?>[] factoryArgs = sam.getParameterTypes();
        Type[] actualCtorArgs = new Type[factoryArgs.length];
        for (int i = 0; i < factoryArgs.length; ++i) {
            actualCtorArgs[i] = Type.getType(factoryArgs[i]);
        }
        String ctorDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])actualCtorArgs);
        ClassNode classNode = new ClassNode(393216);
        classNode.visit(52, 17, containerImplName, null, STATIC_COMPONENT_CONTAINER, null);
        String factoryFieldDescriptor = Type.getDescriptor(componentFactoryType);
        classNode.visitField(10, "componentKeys", "Ljava/util/Set;", "Ljava/util/Set<Ldev/onyxstudios/cca/api/v3/component/ComponentKey<*>;>;", null);
        MethodVisitor keys = classNode.visitMethod(1, "keys", "()Ljava/util/Set;", "()Ljava/util/Set<Ldev/onyxstudios/cca/api/v3/component/ComponentKey<*>;>;", null);
        keys.visitFieldInsn(178, containerImplName, "componentKeys", "Ljava/util/Set;");
        keys.visitInsn(176);
        keys.visitEnd();
        MethodVisitor hasComponents = classNode.visitMethod(1, "hasComponents", "()Z", null, null);
        hasComponents.visitCode();
        hasComponents.visitInsn(sorted.isEmpty() ? 3 : 4);
        hasComponents.visitInsn(172);
        hasComponents.visitEnd();
        MethodVisitor init = classNode.visitMethod(1, "<init>", ctorDesc, null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, STATIC_COMPONENT_CONTAINER, "<init>", ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC, false);
        MethodVisitor serverTick = classNode.visitMethod(1, "tickServerComponents", "()V", null, null);
        serverTick.visitCode();
        MethodVisitor clientTick = classNode.visitMethod(1, "tickClientComponents", "()V", null, null);
        clientTick.visitCode();
        for (Map.Entry<ComponentKey<?>, QualifiedComponentFactory<I>> entry : sorted.entrySet()) {
            class_2960 identifier = entry.getKey().getId();
            String componentFieldName = CcaAsmHelper.getJavaIdentifierName(identifier);
            Class<Component> impl = entry.getValue().impl();
            String componentFieldDescriptor = Type.getDescriptor(impl);
            String factoryFieldName = CcaAsmHelper.getFactoryFieldName(identifier);
            classNode.visitField(10, factoryFieldName, factoryFieldDescriptor, null, null).visitEnd();
            classNode.visitField(18, componentFieldName, componentFieldDescriptor, null, null).visitEnd();
            init.visitFieldInsn(178, containerImplName, factoryFieldName, factoryFieldDescriptor);
            for (int i = 0; i < factoryArgs.length; ++i) {
                init.visitVarInsn(25, i + 1);
            }
            init.visitMethodInsn(185, componentFactoryName, sam.getName(), samDescriptor, true);
            init.visitLdcInsn((Object)("Component factory " + entry.getValue().factory().getClass() + " for " + identifier + " produced a null component"));
            init.visitMethodInsn(184, "java/util/Objects", "requireNonNull", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", false);
            init.visitTypeInsn(192, Type.getInternalName(impl));
            init.visitVarInsn(25, 0);
            init.visitInsn(95);
            init.visitFieldInsn(181, containerImplName, componentFieldName, componentFieldDescriptor);
            MethodVisitor getter = classNode.visitMethod(1, CcaAsmHelper.getStaticStorageGetterName(identifier), STATIC_CONTAINER_GETTER_DESC, null, null);
            getter.visitVarInsn(25, 0);
            getter.visitFieldInsn(180, containerImplName, componentFieldName, componentFieldDescriptor);
            getter.visitInsn(176);
            getter.visitEnd();
            if (ServerTickingComponent.class.isAssignableFrom(impl)) {
                CcaAsmHelper.generateTickImpl(containerImplName, serverTick, componentFieldName, impl, componentFieldDescriptor, "serverTick");
            }
            if (!ClientTickingComponent.class.isAssignableFrom(impl)) continue;
            CcaAsmHelper.generateTickImpl(containerImplName, clientTick, componentFieldName, impl, componentFieldDescriptor, "clientTick");
        }
        init.visitInsn(177);
        init.visitEnd();
        serverTick.visitInsn(177);
        serverTick.visitEnd();
        clientTick.visitInsn(177);
        clientTick.visitEnd();
        Class<ComponentContainer> ret = CcaAsmHelper.generateClass(classNode).asSubclass(ComponentContainer.class);
        try {
            Field keySet = ret.getDeclaredField("componentKeys");
            keySet.setAccessible(true);
            keySet.set(null, Collections.unmodifiableSet(new ReferenceArraySet(sorted.keySet())));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new StaticComponentLoadingException("Failed to initialize the set of component keys for " + ret, e);
        }
        for (Map.Entry<ComponentKey<?>, QualifiedComponentFactory<I>> entry : sorted.entrySet()) {
            try {
                Field factoryField = ret.getDeclaredField(CcaAsmHelper.getFactoryFieldName(entry.getKey().getId()));
                factoryField.setAccessible(true);
                factoryField.set(null, entry.getValue().factory());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new StaticComponentLoadingException("Failed to initialize factory field for component type " + entry.getKey(), e);
            }
        }
        return ret;
    }

    private static void generateTickImpl(String containerImplName, MethodVisitor tick, String componentFieldName, Class<? extends Component> impl, String componentFieldDescriptor, String target) {
        tick.visitVarInsn(25, 0);
        tick.visitFieldInsn(180, containerImplName, componentFieldName, componentFieldDescriptor);
        if (impl.isInterface()) {
            tick.visitMethodInsn(185, Type.getInternalName(impl), target, "()V", true);
        } else {
            tick.visitMethodInsn(182, Type.getInternalName(impl), target, "()V", false);
        }
    }

    private static String getFactoryFieldName(class_2960 identifier) {
        return CcaAsmHelper.getJavaIdentifierName(identifier) + "$factory";
    }

    public static void checkValidJavaIdentifier(String implNameSuffix) {
        for (int i = 0; i < implNameSuffix.length(); ++i) {
            if (Character.isJavaIdentifierPart(implNameSuffix.charAt(i))) continue;
            throw new IllegalArgumentException(implNameSuffix + " is not a valid suffix for a java identifier");
        }
    }

    static {
        try {
            ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC = Type.getConstructorDescriptor(AbstractComponentContainer.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find one or more method descriptors", e);
        }
    }
}

